/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.feed;

import info.msxlaunchers.openmsx.launcher.data.feed.FeedMessage;
import info.msxlaunchers.openmsx.launcher.feed.FeedReader;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;

final class RSSFeedReader
implements FeedReader {
    private static final String ITEM = "item";
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String PUB_DATE = "pubDate";

    RSSFeedReader() {
        this.trustAllCertificates();
    }

    @Override
    public List<FeedMessage> read(String feedUrl, String siteName, String siteUrl) throws IOException {
        ArrayList<FeedMessage> messages = new ArrayList<FeedMessage>();
        String title = "";
        String link = "";
        String pubdate = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (InputStream in = this.readRSSFeed(feedUrl);){
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String localPart;
                    switch (localPart = event.asStartElement().getName().getLocalPart()) {
                        case "title": {
                            title = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "link": {
                            link = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "pubDate": {
                            pubdate = this.getCharacterData(event, eventReader);
                        }
                    }
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(ITEM)) continue;
                FeedMessage message = new FeedMessage(title, link, pubdate, siteName, siteUrl);
                messages.add(message);
                event = eventReader.nextEvent();
            }
        }
        catch (IOException | XMLStreamException e) {
            LauncherLogger.logException(this, e);
            throw new IOException(e);
        }
        return Collections.unmodifiableList(messages);
    }

    private void trustAllCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
    }

    private InputStream readRSSFeed(String feedUrl) throws IOException {
        URLConnection con = new URL(feedUrl).openConnection();
        con.addRequestProperty("user-agent", "oelsha@engineer.com");
        return con.getInputStream();
    }

    private String getCharacterData(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        event = eventReader.nextEvent();
        if (event instanceof Characters) {
            return event.asCharacters().getData();
        }
        return "";
    }
}

